@extends('layouts.panel.base')
@section('role-active', 'kt-menu__item--active')
@section('open-roles-permissions', 'kt-menu__item--open')
@section('title', 'Detalles del Rol')
@section('content')
	<div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor">
		<div class="kt-subheader   kt-grid__item" id="kt_subheader">
			<div class="kt-subheader__main">
				<h3 class="kt-subheader__title">Roles</h3>
				<span class="kt-subheader__separator kt-hidden"></span>
				<div class="kt-subheader__breadcrumbs">
					<a href="{{ route('panel.dashboard') }}" class="kt-subheader__breadcrumbs-home"><i class="flaticon2-shelter"></i></a>
					<span class="kt-subheader__breadcrumbs-separator"></span>
					<a href="{{ route('roles.show', encrypt($role->id)) }}" class="kt-subheader__breadcrumbs-link">
						Detalles
					</a>
				</div>
			</div>
		</div>
		<div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
			<div class="row">
				<div class="col-lg-12">
					<div class="kt-portlet">
						<div class="kt-portlet__head">
							<div class="kt-portlet__head-label">
								<h3 class="kt-portlet__head-title">
									Detalles del Rol
								</h3>
							</div>
						</div>
						<div class="kt-portlet__body">
							@if(Session::has('success'))
					            <div class="alert alert-success" role="alert">
					                <div class="alert-text">{{ Session::get('success') }}</div>
					            </div>
					        @endif
					        <div class="kt-section">
	                            <a href="{{ route('roles.index') }}" class="btn btn-secondary btn-sm btn-margin-bottom" title="Listado">
	                                <span>
	                                    <i class="fas fa-list"></i>
	                                    <span>
	                                        Listado
	                                    </span>
	                                </span>
	                            </a>
	                            <a href="{{ route('roles.create') }}" class="btn btn-primary btn-sm btn-margin-bottom" title="Nuevo">
	                                <span>
	                                    <i class="fas fa-plus"></i>
	                                    <span>
	                                        Nuevo
	                                    </span>
	                                </span>
	                            </a>
	                            <a href="{{ route('roles.edit', encrypt($role->id)) }}" class="btn btn-warning btn-sm btn-margin-bottom" title="Modificar">
	                                <span>
	                                    <i class="fas fa-edit"></i>
	                                    <span>
	                                        Modificar
	                                    </span>
	                                </span>
	                            </a>
					        </div>
					        <div class="kt-separator kt-separator--space-sm  kt-separator--border-dashed"></div>
							<div class="kt-section">
								<h3 class="kt-section__title">Información General</h3>
								<div class="form-group row">
									<div class="col-lg-12">
										<p><b>Nombre:</b> {{ ucfirst($role->name) }}</p>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="row">
			    <div class="col-xl-12">
			        <div class="kt-portlet">
			            <div class="kt-portlet__head">
			                <div class="kt-portlet__head-label">
			                    <h3 class="kt-portlet__head-title">
			                        Historial
			                    </h3>
			                </div>
			            </div>
			            <div class="kt-portlet__body">
			                <div class="kt-section">
			                    <div class="kt-section__content table-responsive">
			                        @if(count($history)>0)
			                            <table class="table">
			                                <thead class="thead-light">
			                                    <tr>
			                                        <th>Estatus</th>
			                                        <th>Usuario</th>
			                                        <th>Fecha</th>
			                                    </tr>
			                                </thead>
			                                <tbody>
			                                    @foreach($history as $key => $value)
			                                        <tr>
			                                            <?php 
			                                            $datos=json_decode($value->data);
			                                            if (isset($datos->motivo)){
			                                                $mensaje=$datos->motivo;
			                                            }elseif (isset($datos->comentario)) {
			                                                $mensaje=$datos->comentario;
			                                            }else{
			                                                $mensaje="";
			                                            } ?>
			                                            <td>{{ $value->status }} @if(isset($datos->motivo) || isset($datos->comentario)) {!! '<br><strong>'.$mensaje.'</strong>' !!} @endif</td>
			                                            <td>
			                                                {{ ucwords($value->user->name) }} {{ ucwords($value->user->last_name) }}
			                                            </td>
			                                            <td>{{ date_format(date_create($value->created_at),"d/m/Y H:i:s") }}</td>
			                                        </tr>
			                                    @endforeach
			                                </tbody>
			                            </table>
			                        @else
			                            <div class="alert alert-outline-danger fade show" role="alert">
			                                <div class="alert-icon"><i class="flaticon-warning"></i></div>
			                                <div class="alert-text">Sin historial registrados</div>
			                            </div>
			                        @endif 
			                    </div>
			                </div>
			            </div>
			        </div>
			    </div>
			</div>
		</div>
	</div>
@endsection
@section('js')
@endsection