@extends('layouts.panel.base')
@section('tourism-active', 'kt-menu__item--active')
@section('title', 'Crear Paquete Turístico')
@section('content')
	<link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
	<style type="text/css">
		.ui-menu-item-wrapper{
			height: 30px !important;
			padding: 10px;
		}
	</style>
	<div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor">
		<div class="kt-subheader   kt-grid__item" id="kt_subheader">
			<div class="kt-subheader__main">
				<h3 class="kt-subheader__title">Paquetes Turísticos</h3>
				<span class="kt-subheader__separator kt-hidden"></span>
				<div class="kt-subheader__breadcrumbs">
					<a href="{{ route('panel.dashboard') }}" class="kt-subheader__breadcrumbs-home"><i class="flaticon2-shelter"></i></a>
					<span class="kt-subheader__breadcrumbs-separator"></span>
					<a href="{{ route('tourism.create') }}" class="kt-subheader__breadcrumbs-link">
						Crear
					</a>
				</div>
			</div>
		</div>
		<div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
			@if(Session::has('error'))
	            <div class="alert alert-danger" role="alert">
	                <div class="alert-text">{{ Session::get('error') }}</div>
	            </div>
	        @endif
			{!! Form::open(['route' => ['tourism.store'], 'method' => 'POST', 'class'=>"kt-form", 'id' => 'create_form']) !!}
				{{ csrf_field() }}
				<div class="row">
					<div class="col-lg-12">
						<div class="kt-portlet">
							<div class="kt-portlet__head">
								<div class="kt-portlet__head-label">
									<h3 class="kt-portlet__head-title">
										Datos del Cliente
									</h3>
								</div>
							</div>
							<div class="kt-portlet__body">
								<div class="row">
									<div class="col-lg">
										<div class="form-group">
											<label>Cliente <span class="input-required">*</span></label>
											{{ Form::text('customer', null, array('class'=>'form-control', 'id'=>'customer')) }}
										</div>
									</div>
									<div class="col-lg">
										<div class="form-group">
											<label>Teléfono <span class="input-required">*</span></label>
											{{ Form::text('phone', null, array('class'=>'form-control', 'id'=>'phone')) }}
										</div>
									</div>
									<div class="col-lg">
										<div class="form-group">
											<label>Correo <span class="input-required">*</span></label>
											{{ Form::text('email', null, array('class'=>'form-control', 'id'=>'email')) }}
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-lg">
										<div class="form-group">
											<label>In <span class="input-required">*</span></label>
											{{ Form::date('in', null, array('class'=>'form-control', 'id'=>'in')) }}
										</div>
									</div>
									<div class="col-lg">
										<div class="form-group">
											<label>Out <span class="input-required">*</span></label>
											{{ Form::date('out', null, array('class'=>'form-control', 'id'=>'out')) }}
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-lg">
										<div class="form-group">
											<label>Zona <span class="input-required">*</span></label>
											{{ Form::text('zone', null, array('class'=>'form-control', 'id'=>'zone')) }}
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="row">
				    <div class="col-xl-12">
				        <div class="kt-portlet kt-portlet--tabs kt-portlet--height-fluid">
				            <div class="kt-portlet__head">
				                <div class="kt-portlet__head-label">
				                    <h3 class="kt-portlet__head-title">
				                        Items
				                    </h3>
				                </div>
				            </div>
				            <div class="kt-portlet__body">
				            	<div class="tab-content">
				            		<div class="tab-pane active" id="kt_widget4_tab1_content">
				            			<div class="kt-widget4">
			    							<div class="row" id="div-error-item" style="display: none;">
			    								<div class="col-lg-12">
			    									<div class="alert alert-danger" role="alert">
			    	                                    <div class="alert-text">
			    	                                        <div id="msg-error-item"></div>
			    	                                    </div>
			    	                                </div>
			    								</div>
			    							</div>
			    							<div class="row">
			    								<div class="col-lg">
			    									<div class="form-group">
			    										<label>Hotel / Hospedaje / Seguros / Transporte<span class="input-required">*</span></label>
			    										{{ Form::select('product', [], '', array('class'=>'form-control kt-select2', 'placeholder'=>'Seleccione producto', 'id'=>'product')) }}
			    									</div>
			    								</div>
			    							</div>
							                <div class="row">
							                	<div class="col-lg">
							                		<div class="form-group">
							                			<label>Tipo <span class="input-required">*</span></label>
							                			<div class="input-group">
							                				<div class="input-group-prepend">
							                					<button type="button" class="btn btn-secondary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
							                						<span class="change_type">Adulto</span>
							                					</button>
							                					<div class="dropdown-menu">
							                						<label class="dropdown-item label_type" attr-value="ADT">Adulto</label>
							                						<label class="dropdown-item label_type" attr-value="CNN">Niño</label>
							                					</div>
							                				</div>
							                				<input type="number" class="form-control" name="number_type" id="number_type" aria-label="">
							                				<input type="hidden" name="type" value="ADT" class="type" id="type">
							                			</div>
							                		</div>
							                	</div>
							                	<div class="col-lg">
							                		<div class="form-group">
							                			<label>Precio <span class="input-required">*</span></label>
							                			{{ Form::number('amount', null, array('class'=>'form-control', 'id'=>'amount')) }}
							                		</div>
							                	</div>
							                	<div class="col-lg">
							                		<div class="form-group">
							                			<label>Cantidad <span class="input-required">*</span></label>
							                			{{ Form::number('quantity', null, array('class'=>'form-control', 'id'=>'quantity')) }}
							                		</div>
							                	</div>
							                	<div class="col-lg">
							                		<div class="form-group">
							                			<label>Total <span class="input-required">*</span></label>
							                			{{ Form::number('total', null, array('class'=>'form-control', 'id'=>'total')) }}
							                		</div>
							                	</div>
							                </div>
							                <div class="row">
							                	<div class="col-lg-10">
							                		<div class="form-group">
							                			<label>Observación <span class="input-required">*</span></label>
							                			{{ Form::text('observation', null, array('class'=>'form-control', 'id'=>'observation')) }}
							                		</div>
							                	</div>
							                	<div class="col-lg-2">
													<div class="form-group">
														<label>Agregar</label><br>
														<button type="button" id="add" class="btn btn-primary"><i class="fa fa-plus"></i></button>
													</div>
												</div>
							                </div>
							                <div class="kt-section__content table-responsive">
							                	<div id="list-item">
							                		@if($items != null)
								                        <table class="table">
								                            <thead class="thead-light">
								                                <tr>
								                                    <th>Tipo</th>
								                                    <th>Hotel / Hospedaje / Seguros / Transporte</th>
								                                    <th>Tarifa</th>
								                                    <th>Cantidad</th>
								                                    <th>Total</th>
								                                    <th></th>
								                                </tr>
								                            </thead>
								                            <tbody>
								                            	@php
								                            		$total_amount = 0;
								                            	@endphp
								                            	@foreach($items as $key => $value)
								                            		@php
								                            			$total_amount = $total_amount + ($value['amount'] * $value['quantity']);
								                            		@endphp
								                                    <tr>
								                                        <td>
								                                        	@if($value['type'] == 'ADT')
								                                        		{{ $value['number_type'] }} Adulto
								                                        	@else
								                                        		{{ $value['number_type'] }} Niño
								                                        	@endif
								                                        </td>
								                                        <td>{{ $value['product'] }}</td>
								                                        <td>$ {{ number_format($value['amount'], 2) }}</td>
								                                        <td>{{ number_format($value['quantity'], 2) }}</td>
								                                        <td>$ {{ number_format($value['total'], 2) }}</td>
								                                        <td>
								                                        	<div class="btn-group btn-group-sm"><button type="button" attr-delete="{{ $key }}" class="btn btn-xs2 btn-danger btn-icon btn-icon-sm delete-item"><i class="fa fa-trash"></i></button></div>
								                                        </td>
								                                    </tr>
								                                @endforeach
								                                <tr>
								                                    <td colspan="3"></td>
								                                    <td>Total</td>
								                                    <td>$ {{ number_format($total_amount, 2) }}</td>
								                                </tr>
								                            </tbody>
								                        </table>
							                        @endif
							                    </div>
							                </div>
							            </div>
						            </div>
					            </div>
				            </div>
				            <div class="kt-portlet__foot">
				            	<div class="kt-form__actions">
				            		<button type="submit" class="btn btn-primary">Enviar</button>
				            		<button type="reset" class="btn btn-secondary">Cancelar</button>
				            	</div>
				            </div>
				        </div>
				    </div>
				</div>
			{!! Form::close(); !!}
		</div>
	</div>
	<div class="modal fade" id="delete" tabindex="-1" role="dialog" aria-labelledby="smallModalLabel" aria-hidden="true">
       	<div class="modal-dialog modal-sm">
           	<div class="modal-content">
               	<div class="modal-header">
                   	<h5 class="modal-title" id="smallModalLabel">Eliminar Item</h5>
                   	<input name="_method" type="hidden" value="DELETE">
                   	<input name="id_delete" id="id_delete" type="hidden" value="">
               	</div>
               	<div class="modal-body">
        			<p class="text-center">¿Quieres eliminar este item?</p>
        		</div>
               	<div class="modal-footer">
               		<button type="button" class="btn btn-secondary" data-dismiss="modal">
            			Cerrar
        			</button>
                   	<button type="button" class="btn btn-danger" data-dismiss="modal" id="item-delete">Confirmar</button>
               	</div>
           	</div>
       	</div>
   	</div>
@endsection
@section('js')
	<script src="{{ asset('panel/assets/vendors/general/jquery-validation/dist/jquery.validate.js') }}" type="text/javascript"></script>
	<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
	<script>
		$('.kt-select2').select2();
		$('#create_form').attr('autocomplete', 'off');
		var token = "{{ csrf_token() }}";
		
		$(document).ready(function() {
		    $('#amount, #quantity').on('input', function() {
		        var amountValue = $('#amount').val();
		        var quantityValue = $('#quantity').val();

		        if ($.isNumeric(amountValue) && $.isNumeric(quantityValue)) {
		            var totalValue = amountValue * quantityValue;
		            $('#total').val(totalValue);
		        } else {
		            $('#total').val('');
		        }
		    });

		    $('.label_type').click(function(){
		    	var type = $(this).attr('attr-value');
		    	if (type == 'ADT') {
		    		var value_type = 'Adulto';
		    	} else {
		    		var value_type = 'Niño';
		    	}
		    	$('.change_type').text(value_type);
		    	$('#type').val(type);
		    });

		    $('#add').click(function(){
		    	var	type = $('#type').val();
		    	var	number_type = $('#number_type').val();
		    	var	product = $('#product').val();
		    	var	amount = $('#amount').val();
		    	var	quantity = $('#quantity').val();
		    	var	total = $('#total').val();
		    	var	observation = $('#observation').val();
		    	var url_add = "{{ route('panel.ajax.tourism.add.item') }}";

		    	if (type == '' || number_type == '' || product == '' || amount == '' || quantity == '' || total == '') {
		    		$('#div-error-item').show();
		    		$('#msg-error-item').html('Debe llenar todos los campos');
		    		$('#div-error-item').fadeIn("slow").delay(2000).fadeOut("slow");
		    	} else {
		    		$('#type').val('').trigger('change');
		    		$('#number_type').val('');
		    		$('#product').val('');
		    		$('#amount').val('');
		    		$('#quantity').val('');
		    		$('#total').val('');
		    		$('#observation').val('');

					$.ajax({
			            url: url_add,
			            type: 'POST',
			            data: { _token: token, type: type, number_type: number_type, product: product, amount: amount, quantity: quantity, total: total, observation: observation },
			            success: function (result) {
			            	$('#list-item').html(result.html);
	                    	$('.delete-item').click(function(){
								var id = $(this).attr('attr-delete');
								$('#delete').modal('show');
				                $('#id_delete').val(id);
							});
			            }
			        });
		    	}
		    });

			$('.delete-item').click(function(){
				var id = $(this).attr('attr-delete');
				$('#delete').modal('show');
                $('#id_delete').val(id);
			});

			$('#item-delete').click(function() {
            	var id = $('#id_delete').val();
            	var url_delete = "{{ route('panel.ajax.tourism.delete.item') }}";
                $.ajax({
                    url: url_delete,
                    type: 'POST',
                    data: { _token: token, id: id },
                    success: function (result) {
                        $('#list-item').html(result.html);
                    	$('.delete-item').click(function(){
							var id = $(this).attr('attr-delete');
							$('#delete').modal('show');
			                $('#id_delete').val(id);
						});
                    }
                });
            });

            $("#zone").autocomplete({
                source: function(request, response) {
                    $.ajax({
                        url: "{{ route('panel.ajax.tourism.search.zone') }}",
                        dataType: "json",
                        data: {
                            term : request.term
                        },
                        success: function(data) {
                            response(data);
                        }
                    });
                },
                minLength: 2,
                select: function(event, ui) {
                    // Llenar el campo de selección de productos con los hoteles correspondientes
                    $.ajax({
                        url: "{{ route('panel.ajax.tourism.select.hotel') }}",
                        dataType: 'json',
                        data: {
                            city: ui.item.value.split(" - ")[0], // Separar el nombre de la ciudad del nombre del país
                            country: ui.item.value.split(" - ")[1]
                        },
                        success: function(data) {
                            $('#product').empty(); // Limpiar el campo de selección de productos
                            $.each(data, function(key, value) {
                                $('#product').append($('<option>').text(value.name).attr('value', value.id));
                            });
                        }
                    });
                }
            });
		});

		$().ready(function() {
            $("#create_form").validate({
                rules: {
                    customer: { required: true },
                    phone: { required: true },
                    email: { required: true },
                    in: { required: true },
					out: { required: true },
					zone: { required: true },
                },
                messages: {
                	customer: "El cliente es requerido.",
                	phone: "El teléfono es requerido.",
                	email: "El email requerido.",
                	in: "La entrada requerida.",
					out: "La salida requerida.",
					zone: "La zona requerida.",
                }
            });
        });
	</script>
@endsection