@extends('layouts.panel.base')
@section('tourism-active', 'kt-menu__item--active')
@section('title', 'Detalles del Presupuesto')
@section('content')
	<div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor">
		<div class="kt-subheader   kt-grid__item" id="kt_subheader">
			<div class="kt-subheader__main">
				<h3 class="kt-subheader__title">Presupuestos</h3>
				<span class="kt-subheader__separator kt-hidden"></span>
				<div class="kt-subheader__breadcrumbs">
					<a href="{{ route('panel.dashboard') }}" class="kt-subheader__breadcrumbs-home"><i class="flaticon2-shelter"></i></a>
					<span class="kt-subheader__breadcrumbs-separator"></span>
					<a href="{{ route('tourism.show', encrypt($tourism->id)) }}" class="kt-subheader__breadcrumbs-link">
						Detalles
					</a>
				</div>
			</div>
		</div>
		<div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
			<div class="row">
				<div class="col-lg-12">
					<div class="kt-portlet">
						<div class="kt-portlet__head">
							<div class="kt-portlet__head-label">
								<h3 class="kt-portlet__head-title">
									Detalles del Presupuesto
								</h3>
							</div>
						</div>
						<div class="kt-portlet__body">
							@if(Session::has('success'))
					            <div class="alert alert-success" role="alert">
					                <div class="alert-text">{{ Session::get('success') }}</div>
					            </div>
					        @endif
					        <div class="kt-section">
	                            <a href="{{ route('tourism.index') }}" class="btn btn-secondary btn-sm btn-margin-bottom" title="Listado">
	                                <span>
	                                    <i class="fas fa-list"></i>
	                                    <span>
	                                        Listado
	                                    </span>
	                                </span>
	                            </a>
	                            <a href="{{ route('tourism.create') }}" class="btn btn-primary btn-sm btn-margin-bottom" title="Nuevo">
	                                <span>
	                                    <i class="fas fa-plus"></i>
	                                    <span>
	                                        Nuevo
	                                    </span>
	                                </span>
	                            </a>
	                            <a href="{{ route('tourism.edit', encrypt($tourism->id)) }}" class="btn btn-warning btn-sm btn-margin-bottom" title="Modificar">
	                                <span>
	                                    <i class="fas fa-edit"></i>
	                                    <span>
	                                        Modificar
	                                    </span>
	                                </span>
	                            </a>
	                            <button data-toggle="modal" data-target="#kt_modal" class="btn btn-danger btn-sm btn-margin-bottom" title="Eliminar">
	                                <span>
	                                    <i class="fas fa-trash"></i>
	                                    <span>
	                                        Eliminar
	                                    </span>
	                                </span>
	                            </button>
	                            <a href="{{ route('panel.budget.escala.send', encrypt($tourism->id)) }}" class="btn btn-info btn-sm btn-margin-bottom" title="Modificar">
	                                <span>
	                                    <i class="fas fa-paper-plane"></i>
	                                    <span>
	                                        Envíar Cotización
	                                    </span>
	                                </span>
	                            </a>
	                            <a href="{{ route('panel.budget.print', encrypt($tourism->id)) }}" class="btn btn-success btn-sm btn-margin-bottom" title="Modificar">
	                                <span>
	                                    <i class="fas fa-print"></i>
	                                    <span>
	                                        Imprimir Cotización
	                                    </span>
	                                </span>
	                            </a>
	                            <!-- <a href="{{ route('panel.tourism.sale', encrypt($tourism->id)) }}" class="btn btn-success btn-sm btn-margin-bottom" title="Modificar">
	                                <span>
	                                    <i class="fas fa-file"></i>
	                                    <span>
	                                        Cerrar Venta
	                                    </span>
	                                </span>
	                            </a> -->
					        </div>
					        <div class="kt-separator kt-separator--space-sm  kt-separator--border-dashed"></div>
							<div class="kt-section">
								<h3 class="kt-section__title">Información General</h3>
								<div class="form-group row">
									<div class="col-lg-6">
										<p><b>Cliente:</b> {{ ucwords($tourism->customer->name) }}</p>
										<p><b>Cliente:</b> {{ ucwords($tourism->customer->phone) }}</p>
										<p><b>In:</b> {{ ucwords($tourism->in) }}</p>
										<p><b>Out:</b> {{ ucwords($tourism->out) }}</p>
										<p><b>Zona:</b> {{ ucwords($tourism->zone) }}</p>
									</div>
									<div class="col-lg-6">
										<p><b>Tipo:</b> {{ $tourism->type }}</p>
										<p><b>Asesor:</b> {{ ucwords(Auth::user()->name) }} {{ ucwords(Auth::user()->last_name) }}</p>
										<p><b>Teléfono:</b> {{ Auth::user()->phone }}</p>
										<p><b>Correo:</b> {{ Auth::user()->email }}</p>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="row">
			    <div class="col-xl-12">
			        <div class="kt-portlet">
			            <div class="kt-portlet__head">
			                <div class="kt-portlet__head-label">
			                    <h3 class="kt-portlet__head-title">
			                        Productos
			                    </h3>
			                </div>
			            </div>
			            <div class="kt-portlet__body">
			                <div class="kt-section">
			                    <div class="kt-section__content table-responsive">
		                            <table class="table">
		                                <thead class="thead-light">
		                                    <tr>
		                                        <th>Descripción</th>
		                                        <th>Cant.</th>
		                                        <th>Precio</th>
		                                        <th>Total</th>
		                                        <th>Observación</th>
		                                    </tr>
		                                </thead>
		                                <tbody>
		                                	@php
		                                		$acum_total = 0;
		                                	@endphp
		                                	@foreach($tourism->tourismDetail as $key => $value)
		                                		@php
		                                			$acum_total = $acum_total + $value->total;
		                                		@endphp
		                                        <tr>
		                                            <td>{{ $value->product }}</td>
		                                            <td>{{ $value->number_type }} {{ $value->type }}</td>
		                                            <td>{{ number_format($value->amount, 2) }}</td>
		                                            <td>{{ number_format($value->total, 2) }}</td>
		                                            <td>{{ $value->observation }}</td>
		                                        </tr>
		                                    @endforeach
		                                    <tr>
		                                    	<td colspan="2"></td>
		                                    	<td><b>Total</b></td>
		                                    	<td><b>{{ number_format($acum_total, 2) }}</b></td>
		                                    	<td></td>
		                                    </tr>
		                                </tbody>
		                            </table>
			                    </div>
			                </div>
			            </div>
			        </div>
			    </div>
			</div>
		</div>
	</div>
	<div class="modal fade" id="kt_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">
                            &times;
                        </span>
                    </button>
                </div>
                {!! Form::open(['route' => ['tourism.destroy', encrypt($tourism->id)], 'method' => 'POST', 'id' => 'form_eliminar']) !!}           
                    <div class="modal-body">
                        <input name="_method" type="hidden" value="DELETE">
                        <h4 class="text-center">¿Desea eliminar el presupuesto?</h4>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">
                            Cerrar
                        </button>
                        <button type="submit" class="btn btn-primary">
                            Confirmar
                        </button>
                    </div>
                    {{ csrf_field() }}
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
@section('js')
@endsection