@extends('layouts.panel.base')
@section('user-active', 'kt-menu__item--active')
@section('title', 'Modificar Usuario')
@section('css')
@endsection
@section('content')
	<div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor">
		<div class="kt-subheader   kt-grid__item" id="kt_subheader">
			<div class="kt-subheader__main">
				<h3 class="kt-subheader__title">Usuario</h3>
				<span class="kt-subheader__separator kt-hidden"></span>
				<div class="kt-subheader__breadcrumbs">
					<a href="{{ route('panel.dashboard') }}" class="kt-subheader__breadcrumbs-home"><i class="flaticon2-shelter"></i></a>
					<span class="kt-subheader__breadcrumbs-separator"></span>
					<a href="{{ route('users.edit', encrypt($user->id)) }}" class="kt-subheader__breadcrumbs-link">
						Modificar
					</a>
				</div>
			</div>
		</div>
		<div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
			<div class="row">
				<div class="col-lg-12">
					<div class="kt-portlet">
						<div class="kt-portlet__head">
							<div class="kt-portlet__head-label">
								<h3 class="kt-portlet__head-title">
									Modificar Usuario
								</h3>
							</div>
						</div>
						{!! Form::open(['route' => ['users.update', encrypt($user->id)], 'method' => 'PUT', 'class'=>"kt-form", 'id' => 'user_form']) !!}
							{{ csrf_field() }}
							@if(count($errors) > 0)
	                            <div class="alert alert-danger" role="alert" style="margin: 10px;">
	                                <ul style="margin-top: 0; margin-bottom: 0rem;">
	                                   @foreach($errors->all() as $error)
	                                       <li>{!! $error !!}</li>
	                                   @endforeach
	                                </ul>                        
	                            </div>
		                    @endif
		                    @if (Session::has('error'))
	                            <div class="alert alert-danger" role="alert" style="margin: 10px;">
	                                <div class="alert-text">{{ Session::get('error') }}</div>
	                            </div>
		                    @endif
							<div class="kt-portlet__body">
								<div class="form-group form-group-last">
									<div class="alert alert-warning" role="alert">
										<div class="alert-icon"><i style="color: #111111 !important;" class="flaticon-warning kt-font-brand"></i></div>
										<div class="alert-text">
											Si no desea realizar cambios en la contraseña, puede dejar dicho campo vacío.
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-lg-6">
										<div class="form-group">
											<label>Nombre <span class="input-required">*</span></label>
											{{ Form::text('name', $user->name, array('class'=>'form-control', 'id'=>'name')) }}
										</div>
									</div>
									<div class="col-lg-6">
										<div class="form-group">
											<label>Apellido <span class="input-required">*</span></label>
											{{ Form::text('last_name', $user->last_name, array('class'=>'form-control', 'id'=>'last_name')) }}
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-lg-6">
										<div class="form-group">
											<label>Email <span class="input-required">*</span></label>
											{{ Form::email('email', $user->email, array('class'=>'form-control', 'id'=>'email')) }}
										</div>
									</div>
									<div class="col-lg-6">
										<div class="form-group">
											<label>Password <span class="input-required">*</span></label>
											<div class="input-group">
												{{ Form::password('password', array('class'=>'form-control', 'id'=>'password')) }}
												<div class="input-group-append">
	            									<button id="show_password" class="btn btn-primary" type="button" onclick="mostrarPassword()"><span class="fa fa-eye-slash icon"></span></button>
	          									</div>
											</div>
											<label id="password-error" class="error" for="password" style="display: none">La contraseña es requerida.</label>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-lg-6">
										<div class="form-group">
											<label>Rol <span class="input-required">*</span></label>
											{{ Form::select('role', $roles, $role->id, array('class'=>'form-control kt-select2', 'placeholder'=>'Seleccione Rol', 'id'=>'role')) }}
											<label style="display: none" id="role-error" class="error" for="role"></label>
										</div>
									</div>
									<div class="col-lg-6">
										<div class="form-group">
											<label>Estatus</label>
											{{ Form::select('status', ['Activo'=>'Activo', 'Inactivo'=>'Inactivo'], $user->status, array('class'=>'form-control kt-select2', 'placeholder'=>'Seleccione Estatus', 'id'=>'status')) }}
											<label style="display: none" id="status-error" class="error" for="status"></label>
										</div>
									</div>
								</div>
							</div>
							<div class="kt-portlet__foot">
								<div class="kt-form__actions">
									<button type="submit" class="btn btn-primary">Enviar</button>
									<button type="reset" class="btn btn-secondary">Cancelar</button>
								</div>
							</div>
						{!! Form::close(); !!}
					</div>
				</div>
			</div>
		</div>
	</div>
@endsection
@section('js')
	<script src="{{ asset('panel/assets/vendors/general/jquery-validation/dist/jquery.validate.js') }}" type="text/javascript"></script>
	<script>
		$('#user_form').attr('autocomplete', 'off');
		$('.kt-select2').select2();
		$("input:text:visible:first").focus();

		$('#role').change(function(){
			var	role = $('#role').val();
			if(role == 7){
				$('#div-device').hide();
			}else{
				$('#div-device').show();
			}
		});

		function mostrarPassword(){
			var cambio = document.getElementById("password");
			if(cambio.type == "password"){
				cambio.type = "text";
				$('.icon').removeClass('fa fa-eye-slash').addClass('fa fa-eye');
			}else{
				cambio.type = "password";
				$('.icon').removeClass('fa fa-eye').addClass('fa fa-eye-slash');
			}
		}

		jQuery.extend(jQuery.validator.messages, {
          	email: jQuery.validator.format("Debe agregar un email."),
        });
		
		$().ready(function() {
            $("#user_form").validate({
                rules: {
                	name: { required: true },
                	last_name: { required: true },
                    email: { required: true, email: true },
                    status: { required: true },
                    role: { required: true },
                },
                messages: {
                	name: "El nombre es requerido.",
                	last_name: "El apellido es requerido.",
                    email: "El email es requerido.",
                    status: "El estatus es requerido.",
                    role: "El rol es requerido.",
                }
            });
        });
	</script>
@endsection