@extends('layouts.website.base')
@section('title', 'Inicio')
@section('content')
	<div class="image-cover hero-header bg-white" style="background:url(website/assets/images/1.jpg)no-repeat;" data-overlay="3">
		<div class="container">
			<div class="row justify-content-center align-items-center">
				<div class="col-xl-10 col-lg-11 col-md-12 col-sm-12">
					<div class="position-relative text-center mb-5">
						<!-- <h1>Descubre un hermoso lugar con 
							<span class="position-relative z-4">Nosotros
								<span class="position-absolute top-50 start-50 translate-middle d-none d-md-block mt-4">
									<svg width="185px" height="23px" viewBox="0 0 445.5 23">
										<path class="fill-white opacity-7"
											d="M409.9,2.6c-9.7-0.6-19.5-1-29.2-1.5c-3.2-0.2-6.4-0.2-9.7-0.3c-7-0.2-14-0.4-20.9-0.5 c-3.9-0.1-7.8-0.2-11.7-0.3c-1.1,0-2.3,0-3.4,0c-2.5,0-5.1,0-7.6,0c-11.5,0-23,0-34.5,0c-2.7,0-5.5,0.1-8.2,0.1 c-6.8,0.1-13.6,0.2-20.3,0.3c-7.7,0.1-15.3,0.1-23,0.3c-12.4,0.3-24.8,0.6-37.1,0.9c-7.2,0.2-14.3,0.3-21.5,0.6 c-12.3,0.5-24.7,1-37,1.5c-6.7,0.3-13.5,0.5-20.2,0.9C112.7,5.3,99.9,6,87.1,6.7C80.3,7.1,73.5,7.4,66.7,8 C54,9.1,41.3,10.1,28.5,11.2c-2.7,0.2-5.5,0.5-8.2,0.7c-5.5,0.5-11,1.2-16.4,1.8c-0.3,0-0.7,0.1-1,0.1c-0.7,0.2-1.2,0.5-1.7,1 C0.4,15.6,0,16.6,0,17.6c0,1,0.4,2,1.1,2.7c0.7,0.7,1.8,1.2,2.7,1.1c6.6-0.7,13.2-1.5,19.8-2.1c6.1-0.5,12.3-1,18.4-1.6 c6.7-0.6,13.4-1.1,20.1-1.7c2.7-0.2,5.4-0.5,8.1-0.7c10.4-0.6,20.9-1.1,31.3-1.7c6.5-0.4,13-0.7,19.5-1.1c2.7-0.1,5.4-0.3,8.1-0.4 c10.3-0.4,20.7-0.8,31-1.2c6.3-0.2,12.5-0.5,18.8-0.7c2.1-0.1,4.2-0.2,6.3-0.2c11.2-0.3,22.3-0.5,33.5-0.8 c6.2-0.1,12.5-0.3,18.7-0.4c2.2-0.1,4.4-0.1,6.7-0.1c11.5-0.1,23-0.2,34.6-0.4c7.2-0.1,14.4-0.1,21.6-0.1c12.2,0,24.5,0.1,36.7,0.1 c2.4,0,4.8,0.1,7.2,0.2c6.8,0.2,13.5,0.4,20.3,0.6c5.1,0.2,10.1,0.3,15.2,0.4c3.6,0.1,7.2,0.4,10.8,0.6c10.6,0.6,21.1,1.2,31.7,1.8 c2.7,0.2,5.4,0.4,8,0.6c2.9,0.2,5.8,0.4,8.6,0.7c0.4,0.1,0.9,0.2,1.3,0.3c1.1,0.2,2.2,0.2,3.2-0.4c0.9-0.5,1.6-1.5,1.9-2.5 c0.6-2.2-0.7-4.5-2.9-5.2c-1.9-0.5-3.9-0.7-5.9-0.9c-1.4-0.1-2.7-0.3-4.1-0.4c-2.6-0.3-5.2-0.4-7.9-0.6 C419.7,3.1,414.8,2.9,409.9,2.6z">
										</path>
									</svg>
								</span>
							</span>
						</h1> -->
						<p class="fs-5 fw-light">
							<img src="{{ asset('website/assets/images/slogan.png') }}" class="img-fluid rounded" alt="" style="width: 240px">
							<!-- Tómate un pequeño descanso del estrés diario. Descubra, planifique un viaje y explore hermosos destinos. -->
						</p>
					</div>
				</div>
				<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
					<div class="search-wrap with-label bg-white rounded-3 p-3 pt-4">
						<div class="row gy-3 gx-md-3 gx-sm-2">
							<div class="col-xl-8 col-lg-7 col-md-12">
								<div class="row gy-3 gx-md-3 gx-sm-2">
									<div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 position-relative">
										<div class="form-group border rounded-1 mb-0">
											<label>Lugar</label>
											<select class="goingto form-control border-0" name="leaving[]" multiple="multiple">
												<option value="ny">New York</option>
												<option value="sd">San Diego</option>
												<option value="sj">San Jose</option>
												<option value="ph">Philadelphia</option>
												<option value="nl">Nashville</option>
												<option value="sf">San Francisco</option>
												<option value="hu">Houston</option>
												<option value="sa">San Antonio</option>
											</select>
										</div>
									</div>
									<div class="col-xl-6 col-lg-6 col-md-6 col-sm-6">
										<div class="form-group mb-0">
											<label>Fecha</label>
											<input type="text" class="form-control fw-bold" placeholder="Check-In & Check-Out"
												id="checkinout" readonly="readonly">
										</div>
									</div>
								</div>
							</div>
							<div class="col-xl-4 col-lg-5 col-md-12">
								<div class="row gy-3 gx-md-3 gx-sm-2">
									<div class="col-xl-8 col-lg-8 col-md-8 col-sm-8">
										<div class="form-group mb-0">
											<label>Personas</label>
											<div class="booking-form__input guests-input mixer-auto">
												<button name="guests-btn" id="guests-input-btn">1 Adulto</button>
												<div class="guests-input__options" id="guests-input-options">
													<div>
														<span class="guests-input__ctrl minus" id="adults-subs-btn"><i
																class="fa-solid fa-minus"></i></span>
														<span class="guests-input__value"><span id="guests-count-adults">1</span>Adultos</span>
														<span class="guests-input__ctrl plus" id="adults-add-btn"><i
																class="fa-solid fa-plus"></i></span>
													</div>
													<div>
														<span class="guests-input__ctrl minus" id="children-subs-btn"><i
																class="fa-solid fa-minus"></i></span>
														<span class="guests-input__value"><span id="guests-count-children">0</span>Niños</span>
														<span class="guests-input__ctrl plus" id="children-add-btn"><i
																class="fa-solid fa-plus"></i></span>
													</div>
													<div>
														<span class="guests-input__ctrl minus" id="room-subs-btn"><i
																class="fa-solid fa-minus"></i></span>
														<span class="guests-input__value"><span id="guests-count-room">0</span>Habit</span>
														<span class="guests-input__ctrl plus" id="room-add-btn"><i
																class="fa-solid fa-plus"></i></span>
													</div>
												</div>
											</div>
										</div>
									</div>
									<div class="col-xl-4 col-lg-4 col-md-4 col-sm-4">
										<div class="form-group mb-0">
											<button type="button" class="btn btn-primary full-width rounded-1 fw-medium"><i
													class="fa-solid fa-magnifying-glass me-2"></i>Buscar</button>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- </row> -->
		</div>
	</div>
	<!-- ============================ Hero Banner End ================================== -->
	<!-- ============================ Best Locations Design Start ================================== -->
	<section class="gray-simple">
		<div class="container">
			<div class="row align-items-center justify-content-center">
				<div class="col-xl-8 col-lg-9 col-md-11 col-sm-12">
					<div class="secHeading-wrap text-center mb-5">
						<h2>Nuestros Servicios</h2>
					</div>
				</div>
			</div>
			<div class="row align-items-center justify-content-center gy-4 gx-3" style="margin-left: 100px; margin-right: 100px;">
				<div class="col-xl-4 col-lg-4 col-md-4 col-sm-6">
					<div class="destination-blocks bg-white p-2 rounded">
						<div class="destination-blocks-pics p-1">
							<a href="#"><img src="{{ asset('website/assets/img/city/c-8.png') }}" class="img-fluid rounded" alt=""></a>
						</div>
						<div class="destination-blocks-captions">
							<div class="touritem-flexxer text-center p-3">
								<h4 class="city fs-5 m-0 fw-bold">
									<span>Boletos Aéreos</span>
								</h4>
							</div>
						</div>
					</div>
				</div>
				<div class="col-xl-4 col-lg-4 col-md-4 col-sm-6">
					<div class="destination-blocks bg-white p-2 rounded">
						<div class="destination-blocks-pics p-1">
							<a href="#"><img src="{{ asset('website/assets/img/city/c-7.png') }}" class="img-fluid rounded" alt=""></a>
						</div>
						<div class="destination-blocks-captions">
							<div class="touritem-flexxer text-center p-3">
								<h4 class="city fs-5 m-0 fw-bold">
									<span>Paquetes Turisticos</span>
								</h4>
							</div>
						</div>
					</div>
				</div>
				<div class="col-xl-4 col-lg-4 col-md-4 col-sm-6">
					<div class="destination-blocks bg-white p-2 rounded">
						<div class="destination-blocks-pics p-1">
							<a href="#"><img src="{{ asset('website/assets/img/city/c-1.png') }}" class="img-fluid rounded" alt=""></a>
						</div>
						<div class="destination-blocks-captions">
							<div class="touritem-flexxer text-center p-3">
								<h4 class="city fs-5 m-0 fw-bold">
									<span>Asesoria Personalizada</span>
								</h4>
							</div>
						</div>
					</div>
				</div>
				<div class="col-xl-4 col-lg-4 col-md-4 col-sm-6">
					<div class="destination-blocks bg-white p-2 rounded">
						<div class="destination-blocks-pics p-1">
							<a href="#"><img src="{{ asset('website/assets/img/city/c-2.png') }}" class="img-fluid rounded" alt=""></a>
						</div>
						<div class="destination-blocks-captions">
							<div class="touritem-flexxer text-center p-3">
								<h4 class="city fs-5 m-0 fw-bold">
									<span>Seguros de Viajes</span>
								</h4>
							</div>
						</div>
					</div>
				</div>
				<div class="col-xl-4 col-lg-4 col-md-4 col-sm-6">
					<div class="destination-blocks bg-white p-2 rounded">
						<div class="destination-blocks-pics p-1">
							<a href="#"><img src="{{ asset('website/assets/img/city/c-3.png') }}" class="img-fluid rounded" alt=""></a>
						</div>
						<div class="destination-blocks-captions">
							<div class="touritem-flexxer text-center p-3">
								<h4 class="city fs-5 m-0 fw-bold">
									<span>Cruceros</span>
								</h4>
							</div>
						</div>
					</div>
				</div>
				<div class="col-xl-4 col-lg-4 col-md-4 col-sm-6">
					<div class="destination-blocks bg-white p-2 rounded">
						<div class="destination-blocks-pics p-1">
							<a href="#"><img src="{{ asset('website/assets/img/city/c-4.png') }}" class="img-fluid rounded" alt=""></a>
						</div>
						<div class="destination-blocks-captions">
							<div class="touritem-flexxer text-center p-3">
								<h4 class="city fs-5 m-0 fw-bold">
									<span>Hoteles</span>
								</h4>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- ============================ Best Locations Design Start ================================== -->
	<!-- ============================ Popular Tours Package Start ================================== -->
	<section>
		<div class="container">

			<div class="row align-items-center justify-content-center">
				<div class="col-xl-8 col-lg-9 col-md-11 col-sm-12">
					<div class="secHeading-wrap text-center mb-5">
						<h2>Nuevas Ofertas</h2>
					</div>
				</div>
			</div>
			<div class="row justify-content-center gy-4 gx-xl-4 gx-3">
				<div class="col-xl-4 col-lg-4 col-md-6 col-sm-12">
					<div class="pop-touritem">
						<a href="#" class="card rounded-3 border br-dashed m-0">
							<div class="flight-thumb-wrapper p-2 pb-0">
								<div class="popFlights-item-overHidden rounded-3">
									<img src="{{ asset('website/assets/img/tours/tour-1.jpg') }}" class="img-fluid" alt="">
								</div>
							</div>
							<div class="touritem-middle position-relative p-3">
								<div class="touritem-flexxer">
									<div class="tourist-wooks position-relative mb-3">
										<ul class="activities-flex">
											<li>
												<div class="actv-wrap">
													<div class="actv-wrap-ico"><i class="fa-solid fa-jet-fighter"></i></div>
													<div class="actv-wrap-caps">3 Vuelos</div>
												</div>
											</li>
											<li>
												<div class="actv-wrap">
													<div class="actv-wrap-ico"><i class="fa-solid fa-building-wheat"></i></div>
													<div class="actv-wrap-caps">3 hoteles</div>
												</div>
											</li>
											<li>
												<div class="actv-wrap">
													<div class="actv-wrap-ico"><i class="fa-solid fa-person-walking-luggage"></i></div>
													<div class="actv-wrap-caps">0 Actividades</div>
												</div>
											</li>
											<li>
												<div class="actv-wrap">
													<div class="actv-wrap-ico"><i class="fa-solid fa-bus"></i></div>
													<div class="actv-wrap-caps">2 Transportes</div>
												</div>
											</li>
										</ul>
									</div>
									<div class="explot">
										<h4 class="city fs-title m-0 fw-bold">
											<span>Amazing Goa Trip Package with Flights</span>
										</h4>
										<div class="rates">
											<div class="rat-reviews">
												<strong><i class="fa-solid fa-star text-warning me-1"></i>4.6</strong><span>(142
													Reviews)</span>
											</div>
										</div>
									</div>
									<div class="touritem-amenties my-4">
										<ul class="activities-flex">
											<li>
												<div class="actv-wrap">
													<div class="actv-wrap-caps text-dark fw-bold fs-6"><span
															class="text-dhani me-1">2N</span>Amman</div>
												</div>
											</li>
											<li>
												<div class="actv-wrap">
													<div class="actv-wrap-caps text-dark fw-bold fs-6"><span
															class="text-dhani me-1">1N</span>Petra</div>
												</div>
											</li>
											<li>
												<div class="actv-wrap">
													<div class="actv-wrap-caps text-dark fw-bold fs-6"><span
															class="text-dhani me-1">2N</span>Dhaka</div>
												</div>
											</li>
										</ul>
									</div>
								</div>
								<div class="booking-wrapes d-flex align-items-start justify-content-start flex-column">
									<h5 class="fs-5 low-price m-0">$<span class="price text-primary">492</span></h5>
									<div class="text-muted-2 text-sm">Para 2 Personas</div>
								</div>
							</div>
						</a>
					</div>
				</div>
				<div class="col-xl-4 col-lg-4 col-md-6 col-sm-12">
					<div class="pop-touritem">
						<a href="#" class="card rounded-3 border br-dashed m-0">
							<div class="flight-thumb-wrapper p-2 pb-0">
								<div class="popFlights-item-overHidden rounded-3">
									<img src="{{ asset('website/assets/img/tours/tour-2.jpg') }}" class="img-fluid" alt="">
								</div>
							</div>
							<div class="touritem-middle position-relative p-3">
								<div class="touritem-flexxer">
									<div class="tourist-wooks position-relative mb-3">
										<ul class="activities-flex">
											<li>
												<div class="actv-wrap">
													<div class="actv-wrap-ico"><i class="fa-solid fa-jet-fighter"></i></div>
													<div class="actv-wrap-caps">3 Vuelos</div>
												</div>
											</li>
											<li>
												<div class="actv-wrap">
													<div class="actv-wrap-ico"><i class="fa-solid fa-building-wheat"></i></div>
													<div class="actv-wrap-caps">3 hoteles</div>
												</div>
											</li>
											<li>
												<div class="actv-wrap">
													<div class="actv-wrap-ico"><i class="fa-solid fa-person-walking-luggage"></i></div>
													<div class="actv-wrap-caps">0 Actividades</div>
												</div>
											</li>
											<li>
												<div class="actv-wrap">
													<div class="actv-wrap-ico"><i class="fa-solid fa-bus"></i></div>
													<div class="actv-wrap-caps">2 Transportes</div>
												</div>
											</li>
										</ul>
									</div>
									<div class="explot">
										<h4 class="city fs-title m-0 fw-bold">
											<span>Electrifying Trip to Goa</span>
										</h4>
										<div class="rates">
											<div class="rat-reviews">
												<strong><i class="fa-solid fa-star text-warning me-1"></i>4.6</strong><span>(142
													Reviews)</span>
											</div>
										</div>
									</div>
									<div class="touritem-amenties my-4">
										<ul class="activities-flex">
											<li>
												<div class="actv-wrap">
													<div class="actv-wrap-caps text-dark fw-bold fs-6"><span
															class="text-dhani me-1">2N</span>Amman</div>
												</div>
											</li>
											<li>
												<div class="actv-wrap">
													<div class="actv-wrap-caps text-dark fw-bold fs-6"><span
															class="text-dhani me-1">1N</span>Petra</div>
												</div>
											</li>
											<li>
												<div class="actv-wrap">
													<div class="actv-wrap-caps text-dark fw-bold fs-6"><span
															class="text-dhani me-1">2N</span>Dhaka</div>
												</div>
											</li>
										</ul>
									</div>
								</div>
								<div class="booking-wrapes d-flex align-items-start justify-content-start flex-column">
									<h5 class="fs-5 low-price m-0">$<span class="price text-primary">569</span></h5>
									<div class="text-muted-2 text-sm">Para 2 Personas</div>
								</div>
							</div>
						</a>
					</div>
				</div>
				<div class="col-xl-4 col-lg-4 col-md-6 col-sm-12">
					<div class="pop-touritem">
						<a href="#" class="card rounded-3 border br-dashed m-0">
							<div class="flight-thumb-wrapper p-2 pb-0">
								<div class="popFlights-item-overHidden rounded-3">
									<img src="{{ asset('website/assets/img/tours/tour-3.jpg') }}" class="img-fluid" alt="">
								</div>
							</div>
							<div class="touritem-middle position-relative p-3">
								<div class="touritem-flexxer">
									<div class="tourist-wooks position-relative mb-3">
										<ul class="activities-flex">
											<li>
												<div class="actv-wrap">
													<div class="actv-wrap-ico"><i class="fa-solid fa-jet-fighter"></i></div>
													<div class="actv-wrap-caps">3 Vuelos</div>
												</div>
											</li>
											<li>
												<div class="actv-wrap">
													<div class="actv-wrap-ico"><i class="fa-solid fa-building-wheat"></i></div>
													<div class="actv-wrap-caps">3 hoteles</div>
												</div>
											</li>
											<li>
												<div class="actv-wrap">
													<div class="actv-wrap-ico"><i class="fa-solid fa-person-walking-luggage"></i></div>
													<div class="actv-wrap-caps">0 Actividades</div>
												</div>
											</li>
											<li>
												<div class="actv-wrap">
													<div class="actv-wrap-ico"><i class="fa-solid fa-bus"></i></div>
													<div class="actv-wrap-caps">2 Transportes</div>
												</div>
											</li>
										</ul>
									</div>
									<div class="explot">
										<h4 class="city fs-title m-0 fw-bold">
											<span>Thrilling Holiday in Goa</span>
										</h4>
										<div class="rates">
											<div class="rat-reviews">
												<strong><i class="fa-solid fa-star text-warning me-1"></i>4.6</strong><span>(142
													Reviews)</span>
											</div>
										</div>
									</div>
									<div class="touritem-amenties my-4">
										<ul class="activities-flex">
											<li>
												<div class="actv-wrap">
													<div class="actv-wrap-caps text-dark fw-bold fs-6"><span
															class="text-dhani me-1">2N</span>Amman</div>
												</div>
											</li>
											<li>
												<div class="actv-wrap">
													<div class="actv-wrap-caps text-dark fw-bold fs-6"><span
															class="text-dhani me-1">1N</span>Petra</div>
												</div>
											</li>
											<li>
												<div class="actv-wrap">
													<div class="actv-wrap-caps text-dark fw-bold fs-6"><span
															class="text-dhani me-1">2N</span>Dhaka</div>
												</div>
											</li>
										</ul>
									</div>
								</div>
								<div class="booking-wrapes d-flex align-items-start justify-content-start flex-column">
									<h5 class="fs-5 low-price m-0">$<span class="price text-primary">479</span></h5>
									<div class="text-muted-2 text-sm">Para 2 Personas</div>
								</div>
							</div>
						</a>
					</div>
				</div>
			</div>
			<div class="row align-items-center justify-content-center">
				<div class="col-xl-12 col-lg-12 col-md-12">
					<div class="text-center position-relative mt-5">
						<button type="button" class="btn btn-light-primary fw-medium px-5">Ver Más<i class="fa-solid fa-plus ms-2"></i></button>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- ============================ Popular Tours Package Start ================================== -->
	<!-- ============================ Popular Flights Routes Start ================================== -->
	<section class="gray-simple pt-5">
		<div class="container">
			<div class="row align-items-center justify-content-center">
				<div class="col-xl-8 col-lg-9 col-md-11 col-sm-12">
					<div class="secHeading-wrap text-center mb-5">
						<h2>Ofertas para rutas de vuelos</h2>
						<p>Aprovecha nuestros precios y disfruta de las vacaciones de tus sueños.</p>
					</div>
				</div>
			</div>
			<div class="row justify-content-center">
				<div class="col-xl-12 col-lg-12 col-md-12 p-0">
					<div class="main-carousel cols-4 dots-full">
						<!-- Single Item -->
						<div class="carousel-cell">
							<div class="card rounded-3 border-0 m-0 fltsOffers-card">
								<div class="card-body">
									<div class="d-inline-flex mb-3"><span class="label bg-danger text-light">20% Descuento</span></div>
									<div class="fltsOffers-flex d-flex align-items-center justify-content-between">
										<div class="fltsOffers-firster">
											<h6 class="text-dark fw-bold fs-6 m-0">DHL</h6>
											<p class="text-muted-2 text-md m-0">Delhi</p>
										</div>
										<div class="fltsOffers-middler text-muted fs-5"><i class="fa-solid fa-jet-fighter"></i></div>
										<div class="fltsOffers-ender">
											<h6 class="text-dark fw-bold fs-6 m-0">NWK</h6>
											<p class="text-muted-2 text-md m-0">New York</p>
										</div>
									</div>
									<div class="fltsFlite-name d-flex flex-column align-items-center justify-content-center my-3">
										<p class="text-muted m-0">a</p>
										<h6 class="fw-bold text-dhani">20 Sep - 10 Oct</h6>
									</div>
									<div class="fltsFlite-name d-flex align-items-center justify-content-center mb-1">
										<img src="{{ asset('website/assets/img/flt-1.png') }}" class="img-fluid" width="120" alt="">
									</div>
								</div>
							</div>
						</div>
						<!-- Single Item -->
						<div class="carousel-cell">
							<div class="card rounded-3 border-0 m-0 fltsOffers-card">
								<div class="card-body">
									<div class="d-inline-flex mb-3"><span class="label bg-warning text-light">Agregado Riciente</span></div>
									<div class="fltsOffers-flex d-flex align-items-center justify-content-between">
										<div class="fltsOffers-firster">
											<h6 class="text-dark fw-bold fs-6 m-0">DHL</h6>
											<p class="text-muted-2 text-md m-0">Delhi</p>
										</div>
										<div class="fltsOffers-middler text-muted fs-5"><i class="fa-solid fa-jet-fighter"></i></div>
										<div class="fltsOffers-ender">
											<h6 class="text-dark fw-bold fs-6 m-0">NWK</h6>
											<p class="text-muted-2 text-md m-0">New York</p>
										</div>
									</div>
									<div class="fltsFlite-name d-flex flex-column align-items-center justify-content-center my-3">
										<p class="text-muted m-0">a</p>
										<h6 class="fw-bold text-dhani">20 Sep - 10 Oct</h6>
									</div>
									<div class="fltsFlite-name d-flex align-items-center justify-content-center mb-1">
										<img src="{{ asset('website/assets/img/flt-2.png') }}" class="img-fluid" width="120" alt="">
									</div>
								</div>
							</div>
						</div>
						<!-- Single Item -->
						<div class="carousel-cell">
							<div class="card rounded-3 border-0 m-0 fltsOffers-card">
								<div class="card-body">
									<div class="d-inline-flex mb-3"><span class="label bg-danger text-light">30% Descuento</span></div>
									<div class="fltsOffers-flex d-flex align-items-center justify-content-between">
										<div class="fltsOffers-firster">
											<h6 class="text-dark fw-bold fs-6 m-0">DHL</h6>
											<p class="text-muted-2 text-md m-0">Delhi</p>
										</div>
										<div class="fltsOffers-middler text-muted fs-5"><i class="fa-solid fa-jet-fighter"></i></div>
										<div class="fltsOffers-ender">
											<h6 class="text-dark fw-bold fs-6 m-0">NWK</h6>
											<p class="text-muted-2 text-md m-0">New York</p>
										</div>
									</div>
									<div class="fltsFlite-name d-flex flex-column align-items-center justify-content-center my-3">
										<p class="text-muted m-0">a</p>
										<h6 class="fw-bold text-dhani">20 Sep - 10 Oct</h6>
									</div>
									<div class="fltsFlite-name d-flex align-items-center justify-content-center mb-1">
										<img src="{{ asset('website/assets/img/flt-3.png') }}" class="img-fluid" width="120" alt="">
									</div>
								</div>
							</div>
						</div>
						<!-- Single Item -->
						<div class="carousel-cell">
							<div class="card rounded-3 border-0 m-0 fltsOffers-card">
								<div class="card-body">
									<div class="d-inline-flex mb-3"><span class="label bg-success text-light">Recomendaado</span></div>
									<div class="fltsOffers-flex d-flex align-items-center justify-content-between">
										<div class="fltsOffers-firster">
											<h6 class="text-dark fw-bold fs-6 m-0">DHL</h6>
											<p class="text-muted-2 text-md m-0">Delhi</p>
										</div>
										<div class="fltsOffers-middler text-muted fs-5"><i class="fa-solid fa-jet-fighter"></i></div>
										<div class="fltsOffers-ender">
											<h6 class="text-dark fw-bold fs-6 m-0">NWK</h6>
											<p class="text-muted-2 text-md m-0">New York</p>
										</div>
									</div>
									<div class="fltsFlite-name d-flex flex-column align-items-center justify-content-center my-3">
										<p class="text-muted m-0">a</p>
										<h6 class="fw-bold text-dhani">20 Sep - 10 Oct</h6>
									</div>
									<div class="fltsFlite-name d-flex align-items-center justify-content-center mb-1">
										<img src="{{ asset('website/assets/img/flt-4.png') }}" class="img-fluid" width="120" alt="">
									</div>
								</div>
							</div>
						</div>

						<!-- Single Item -->
						<div class="carousel-cell">
							<div class="card rounded-3 border-0 m-0 fltsOffers-card">
								<div class="card-body">
									<div class="d-inline-flex mb-3"><span class="label bg-warning text-light">Tendencia</span></div>
									<div class="fltsOffers-flex d-flex align-items-center justify-content-between">
										<div class="fltsOffers-firster">
											<h6 class="text-dark fw-bold fs-6 m-0">DHL</h6>
											<p class="text-muted-2 text-md m-0">Delhi</p>
										</div>
										<div class="fltsOffers-middler text-muted fs-5"><i class="fa-solid fa-jet-fighter"></i></div>
										<div class="fltsOffers-ender">
											<h6 class="text-dark fw-bold fs-6 m-0">NWK</h6>
											<p class="text-muted-2 text-md m-0">New York</p>
										</div>
									</div>
									<div class="fltsFlite-name d-flex flex-column align-items-center justify-content-center my-3">
										<p class="text-muted m-0">a</p>
										<h6 class="fw-bold text-dhani">20 Sep - 10 Oct</h6>
									</div>
									<div class="fltsFlite-name d-flex align-items-center justify-content-center mb-1">
										<img src="{{ asset('website/assets/img/flt-1.png') }}" class="img-fluid" width="120" alt="">
									</div>
								</div>
							</div>
						</div>

						<!-- Single Item -->
						<div class="carousel-cell">
							<div class="card rounded-3 border-0 m-0 fltsOffers-card">
								<div class="card-body">
									<div class="d-inline-flex mb-3"><span class="label bg-danger text-light">20% Descuento</span></div>
									<div class="fltsOffers-flex d-flex align-items-center justify-content-between">
										<div class="fltsOffers-firster">
											<h6 class="text-dark fw-bold fs-6 m-0">DHL</h6>
											<p class="text-muted-2 text-md m-0">Delhi</p>
										</div>
										<div class="fltsOffers-middler text-muted fs-5"><i class="fa-solid fa-jet-fighter"></i></div>
										<div class="fltsOffers-ender">
											<h6 class="text-dark fw-bold fs-6 m-0">NWK</h6>
											<p class="text-muted-2 text-md m-0">New York</p>
										</div>
									</div>
									<div class="fltsFlite-name d-flex flex-column align-items-center justify-content-center my-3">
										<p class="text-muted m-0">a</p>
										<h6 class="fw-bold text-dhani">20 Sep - 10 Oct</h6>
									</div>
									<div class="fltsFlite-name d-flex align-items-center justify-content-center mb-1">
										<img src="{{ asset('website/assets/img/flt-3.png') }}" class="img-fluid" width="120" alt="">
									</div>
								</div>
							</div>
						</div>

					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- ============================ Popular Flights Routes End ================================== -->
	<!-- ============================ Our Reviews Start ================================== -->
	<section class="gray">
		<div class="container">
			<div class="row align-items-center justify-content-center">
				<div class="col-xl-8 col-lg-9 col-md-11 col-sm-12">
					<div class="secHeading-wrap text-center mb-5">
						<h2>Reseñas De Nuestros Clientes</h2>
					</div>
				</div>
			</div>
			<div class="row align-items-center justify-content-center g-xl-4 g-lg-4 g-md-4 g-3">
				<div class="col-xl-4 col-lg-4 col-md-6 col-sm-6">
					<div class="card border-0 rounded-3">
						<div class="card-body">
							<div class="position-absolute top-0 end-0 mt-3 me-3"><span
									class="square--40 circle text-primary bg-light-primary"><i
										class="fa-solid fa-quote-right"></i></span></div>
							<div class="d-flex align-items-center flex-thumbes">
								<div class="revws-pic"><img src="{{ asset('website/assets/img/team-1.jpg') }}" class="img-fluid rounded-2" width="80" alt=""></div>
								<div class="revws-caps ps-3">
									<h6 class="fw-bold fs-6 m-0">Aman Diwakar</h6>
									<p class="text-muted-2 text-md m-0">United States</p>
									<div class="d-flex align-items-center justify-content-start">
										<span class="me-1 text-xs text-warning"><i class="fa-solid fa-star"></i></span>
										<span class="me-1 text-xs text-warning"><i class="fa-solid fa-star"></i></span>
										<span class="me-1 text-xs text-warning"><i class="fa-solid fa-star"></i></span>
										<span class="me-1 text-xs text-warning"><i class="fa-solid fa-star"></i></span>
										<span class="me-1 text-xs text-warning"><i class="fa-solid fa-star"></i></span>
									</div>
								</div>
							</div>
							<div class="revws-desc mt-3">
								<p class="m-0 text-md"> Desde el momento en que entré en la agencia, supe que estaba en buenas manos. El equipo fue extremadamente servicial y conocedor, ayudándome a planificar el viaje de mis sueños sin importar lo complicado que pareciera.</p>
							</div>
						</div>
					</div>
				</div>
				<div class="col-xl-4 col-lg-4 col-md-6 col-sm-6">
					<div class="card border-0 rounded-3">
						<div class="card-body">
							<div class="position-absolute top-0 end-0 mt-3 me-3"><span
									class="square--40 circle text-primary bg-light-primary"><i
										class="fa-solid fa-quote-right"></i></span></div>
							<div class="d-flex align-items-center flex-thumbes">
								<div class="revws-pic"><img src="{{ asset('website/assets/img/team-2.jpg') }}" class="img-fluid rounded-2" width="80" alt=""></div>
								<div class="revws-caps ps-3">
									<h6 class="fw-bold fs-6 m-0">Kunal M. Thakur</h6>
									<p class="text-muted-2 text-md m-0">United States</p>
									<div class="d-flex align-items-center justify-content-start">
										<span class="me-1 text-xs text-warning"><i class="fa-solid fa-star"></i></span>
										<span class="me-1 text-xs text-warning"><i class="fa-solid fa-star"></i></span>
										<span class="me-1 text-xs text-warning"><i class="fa-solid fa-star"></i></span>
										<span class="me-1 text-xs text-warning"><i class="fa-solid fa-star"></i></span>
										<span class="me-1 text-xs text-warning"><i class="fa-solid fa-star"></i></span>
									</div>
								</div>
							</div>
							<div class="revws-desc mt-3">
								<p class="m-0 text-md">Mi experiencia con esta agencia de viajes fue excepcional desde el primer contacto. El personal fue increíblemente amable, siempre dispuesto a responder a mis preguntas y adaptarse a mis necesidades específicas.</p>
							</div>
						</div>
					</div>
				</div>
				<div class="col-xl-4 col-lg-4 col-md-6 col-sm-6">
					<div class="card border-0 rounded-3">
						<div class="card-body">
							<div class="position-absolute top-0 end-0 mt-3 me-3"><span
									class="square--40 circle text-primary bg-light-primary"><i
										class="fa-solid fa-quote-right"></i></span></div>
							<div class="d-flex align-items-center flex-thumbes">
								<div class="revws-pic"><img src="{{ asset('website/assets/img/team-3.jpg') }}" class="img-fluid rounded-2" width="80" alt=""></div>
								<div class="revws-caps ps-3">
									<h6 class="fw-bold fs-6 m-0">Divya Talwar</h6>
									<p class="text-muted-2 text-md m-0">United States</p>
									<div class="d-flex align-items-center justify-content-start">
										<span class="me-1 text-xs text-warning"><i class="fa-solid fa-star"></i></span>
										<span class="me-1 text-xs text-warning"><i class="fa-solid fa-star"></i></span>
										<span class="me-1 text-xs text-warning"><i class="fa-solid fa-star"></i></span>
										<span class="me-1 text-xs text-warning"><i class="fa-solid fa-star"></i></span>
										<span class="me-1 text-xs text-warning"><i class="fa-solid fa-star"></i></span>
									</div>
								</div>
							</div>
							<div class="revws-desc mt-3">
								<p class="m-0 text-md">No puedo agradecer lo suficiente por hacer que mi última aventura fuera verdaderamente memorable. Desde la primera consulta hasta el regreso a casa, su atención al detalle y su dedicación a garantizar una experiencia perfecta fueron evidentes en todo momento.</p>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- ============================ Our Reviews End ================================== -->
	<!-- ================================ Article Section Start ======================================= -->
	<!-- <section>
		<div class="container">
			<div class="row align-items-center justify-content-center">
				<div class="col-xl-8 col-lg-9 col-md-11 col-sm-12">
					<div class="secHeading-wrap text-center mb-5">
						<h2>Trending & Popular Articles</h2>
						<p>Cicero famously orated against his political opponent Lucius Sergius Catilina.</p>
					</div>
				</div>
			</div>
			<div class="row align-items-center justify-content-center g-4">
				<div class="col-xl-4 col-lg-4 col-md-4 col-sm-12">
					<div class="blogGrid-wrap d-flex flex-column h-100">
						<div class="blogGrid-pics">
							<a href="#" class="d-block"><img src="{{ asset('website/assets/img/blog-1.jpg') }}" class="img-fluid rounded" alt="Blog image"></a>
						</div>
						<div class="blogGrid-caps pt-3">
							<div class="d-flex align-items-center mb-1"><span
									class="label text-success bg-light-success">Destination</span></div>
							<h4 class="fw-bold fs-6 lh-base"><a href="#" class="text-dark">Make Your Next Journey Delhi To Paris in
									Comfirtable And Best Price</a></h4>
							<p class="mb-3">Think of a news blog that's filled with content hourly on the Besides, random text risks
								to be unintendedly humorous or offensive day of going live.</p>
							<a class="text-primary fw-medium" href="#">Read More<i class="fa-solid fa-arrow-trend-up ms-2"></i></a>
						</div>
					</div>
				</div>
				<div class="col-xl-4 col-lg-4 col-md-4 col-sm-12">
					<div class="blogGrid-wrap d-flex flex-column h-100">
						<div class="blogGrid-pics">
							<a href="#" class="d-block"><img src="{{ asset('website/assets/img/blog-2.jpg') }}" class="img-fluid rounded" alt="Blog image"></a>
						</div>
						<div class="blogGrid-caps pt-3">
							<div class="d-flex align-items-center mb-1"><span
									class="label text-success bg-light-success">Journey</span></div>
							<h4 class="fw-bold fs-6 lh-base"><a href="#" class="text-dark">Make Your Next Journey Delhi To Paris in
									Comfirtable And Best Price</a></h4>
							<p class="mb-3">Think of a news blog that's filled with content hourly on the Besides, random text risks
								to be unintendedly humorous or offensive day of going live.</p>
							<a class="text-primary fw-medium" href="#">Read More<i class="fa-solid fa-arrow-trend-up ms-2"></i></a>
						</div>
					</div>
				</div>

				<div class="col-xl-4 col-lg-4 col-md-4 col-sm-12">
					<div class="blogGrid-wrap d-flex flex-column h-100">
						<div class="blogGrid-pics">
							<a href="#" class="d-block"><img src="{{ asset('website/assets/img/blog-3.jpg') }}" class="img-fluid rounded" alt="Blog image"></a>
						</div>
						<div class="blogGrid-caps pt-3">
							<div class="d-flex align-items-center mb-1"><span
									class="label text-success bg-light-success">Business</span></div>
							<h4 class="fw-bold fs-6 lh-base"><a href="#" class="text-dark">Make Your Next Journey Delhi To Paris in
									Comfirtable And Best Price</a></h4>
							<p class="mb-3">Think of a news blog that's filled with content hourly on the Besides, random text risks
								to be unintendedly humorous or offensive day of going live.</p>
							<a class="text-primary fw-medium" href="#">Read More<i class="fa-solid fa-arrow-trend-up ms-2"></i></a>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section> -->
	<!-- ================================ Article Section Start ======================================= -->
	<!-- ============================ Call To Action Start ================================== -->
	<div class="position-relative bg-cover bg-primary" style="background:url(website/assets/img/bg.jpg)no-repeat;" data-overlay="5">
		<div class="container">
			<div class="row align-items-center justify-content-between">
				<div class="col-xl-12 col-lg-12 col-md-12">
					<div class="calltoAction-wraps position-relative py-5 px-4">
						<div class="ht-40"></div>
						<div class="row align-items-center justify-content-center">
							<div class="col-xl-8 col-lg-9 col-md-10 col-sm-11 text-center">

								<div class="calltoAction-title mb-5">
									<h4 class="text-light fs-2 fw-bold lh-base m-0">Suscribete y Resive Nuestras Ofertas
									</h4>
								</div>
								<div class="newsletter-forms mt-md-0 mt-4">
									<form>
										<div class="row align-items-center justify-content-between bg-white rounded-3 p-2 gx-0">

											<div class="col-xl-9 col-lg-8 col-md-8">
												<div class="form-group m-0">
													<input type="text" class="form-control bold ps-1 border-0" placeholder="Ingrese su Correo">
												</div>
											</div>
											<div class="col-xl-3 col-lg-4 col-md-4">
												<div class="form-group m-0">
													<button type="button" class="btn btn-primary fw-medium full-width">Suscribirse</button>
												</div>
											</div>
										</div>
									</form>
								</div>
							</div>
						</div>
						<div class="ht-40"></div>
					</div>
				</div>
			</div>
		</div>
	</div>
@endsection