<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Panel\DashboardController;
use App\Http\Controllers\Panel\ProfileController;
use App\Http\Controllers\Panel\UserController;
use App\Http\Controllers\Panel\PermissionController;
use App\Http\Controllers\Panel\RoleController;
use App\Http\Controllers\Panel\AjaxController;
use App\Http\Controllers\Panel\FlightController;
use App\Http\Controllers\Panel\CountryController;
use App\Http\Controllers\Panel\StateController;
use App\Http\Controllers\Panel\CityController;
use App\Http\Controllers\Panel\AirportController;
use App\Http\Controllers\Panel\AirlineController;
use App\Http\Controllers\Panel\AjaxLocationController;
use App\Http\Controllers\Panel\AjaxFlightController;
use App\Http\Controllers\Panel\BookingController;
use App\Http\Controllers\Panel\ViewController;
use App\Http\Controllers\Panel\TourismController;
use App\Http\Controllers\Panel\AjaxTourismController;
use App\Http\Controllers\Panel\HotelController;
use App\Http\Controllers\Website\PageController;
use App\Http\Controllers\TestController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

/*Route::get('/', function () {
    return view('welcome');
});*/
/*Route::get('/', function () {
    return redirect()->route('login');
});*/
Route::get('/', [PageController::class, 'index'])->name('website.index');
Route::get('/nosotros', [PageController::class, 'aboutUs'])->name('website.about');
Route::get('/contacto', [PageController::class, 'contact'])->name('website.contact');
//Route::get('/test', [TestController::class, 'test'])->name('test');
Auth::routes();
//Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
Route::group(['prefix' => 'panel', 'middleware' => 'auth'], function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('panel.dashboard');
    Route::get('/profile/edit', [ProfileController::class, 'edit'])->name('panel.profile.edit');
    Route::put('/profile/update', [ProfileController::class, 'update'])->name('panel.profile.update');
    Route::resource('airports', AirportController::class);
    Route::resource('airlines', AirlineController::class);
    Route::resource('countries', CountryController::class);
    Route::resource('states', StateController::class);
    Route::resource('cities', CityController::class);
    Route::resource('users', UserController::class);
    Route::resource('roles', RoleController::class);
    Route::resource('bookings', BookingController::class);
    Route::get('/permissions/assignment', [PermissionController::class, 'assignment'])->name('panel.permissions.assignment');
    Route::post('/permissions/assignment/save', [PermissionController::class, 'assignmentSave'])->name('panel.permissions.assignment.save');
    Route::resource('permissions', PermissionController::class);
    Route::post('/permissions/assignment/save', [PermissionController::class, 'assignmentSave'])->name('panel.permissions.assignment.save');
    Route::get('/flights', [FlightController::class, 'flights'])->name('panel.flights');
    Route::post('/flights/query', [FlightController::class, 'query'])->name('panel.flights.query');
    Route::get('/flights/result', [FlightController::class, 'result'])->name('panel.flights.result');
    Route::get('/flights/customer', [FlightController::class, 'customer'])->name('panel.flights.customer');
    Route::post('/flights/customer/save', [FlightController::class, 'customerSave'])->name('panel.flights.customer.save');
    Route::get('/flights/booking/{id}', [FlightController::class, 'booking'])->name('panel.flights.booking');
    Route::get('/flights/booking/cancel/{id}', [FlightController::class, 'bookingCancel'])->name('panel.flights.booking.cancel');
    Route::get('/flights/seating/{id}', [FlightController::class, 'seating'])->name('panel.flights.seating');
    Route::get('/flights/seating-select/{id}', [FlightController::class, 'seatingSelect'])->name('panel.flights.seating.select');
    Route::get('/flights/seating/save/{id}', [FlightController::class, 'seatingSave'])->name('panel.flights.seating.save');
    Route::get('/flights/issue/tickets/{id}', [FlightController::class, 'issueTickets'])->name('panel.flights.issue.tickets');
    Route::get('/tourism/sale/{id}', [TourismController::class, 'sale'])->name('panel.tourism.sale');
    Route::resource('tourism', TourismController::class);
    Route::get('/hotels/detail/{id}', [HotelController::class, 'detail'])->name('panel.hotels.detail');
    Route::post('/hotels/detail/save/{id}', [HotelController::class, 'detailSave'])->name('panel.hotels.detail.save');
    Route::get('/hotels/room/{id}', [HotelController::class, 'room'])->name('panel.hotels.room');
    Route::post('/hotels/room/save/{id}', [HotelController::class, 'roomSave'])->name('panel.hotels.room.save');
    Route::get('/hotels/room/edit/{id}', [HotelController::class, 'roomEdit'])->name('panel.hotels.room.edit');
    Route::post('/hotels/room/update/{id}', [HotelController::class, 'roomUpdate'])->name('panel.hotels.room.update');
    Route::get('/hotels/room/price/{id}', [HotelController::class, 'roomPrice'])->name('panel.hotels.room.price');
    Route::post('/hotels/detail/add/amenities', [HotelController::class, 'addAmenities'])->name('panel.hotels.detail.add.amenities');
    Route::post('/hotels/detail/delete/amenities', [HotelController::class, 'deleteAmenities'])->name('panel.hotels.detail.delete.amenities');
    Route::post('/hotels/add/date', [HotelController::class, 'addDate'])->name('panel.hotels.add.date');
    Route::post('/hotels/delete/date', [HotelController::class, 'deleteDate'])->name('panel.hotels.delete.date');
    Route::post('/hotels/room/price/save/{id}', [HotelController::class, 'roomPriceSave'])->name('panel.hotels.room.price.save');
    Route::get('/hotels/room/price/delete/{id}', [HotelController::class, 'roomPriceDelete'])->name('panel.hotels.room.price.delete');
    //Route::get('/amenities/search', 'AmenityController@search')->name('amenities.search');
    Route::get('/amenities/search', [HotelController::class, 'search'])->name('amenities.search');
    Route::resource('hotels', HotelController::class);

    
    Route::get('/test', [ViewController::class, 'index'])->name('panel.flights.test');

    Route::post('/role/assignment', [AjaxController::class, 'roleAssignment'])->name('panel.ajax.role.assignment');
    Route::post('state', [AjaxLocationController::class, 'state'])->name('panel.ajax.state');
    Route::post('city', [AjaxLocationController::class, 'city'])->name('panel.ajax.city');
    Route::post('destination-airport', [AjaxFlightController::class, 'destinationAirport'])->name('panel.ajax.destination.airport');
    Route::post('select-fee-departure', [AjaxFlightController::class, 'selectFeeDeparture'])->name('panel.ajax.select.fee.departure');
    Route::post('select-fee-return', [AjaxFlightController::class, 'selectFeeReturn'])->name('panel.ajax.select.fee.return');
    Route::post('select-seating', [AjaxFlightController::class, 'selectSeating'])->name('panel.ajax.select.seating');
    Route::post('add-item', [AjaxTourismController::class, 'addItem'])->name('panel.ajax.tourism.add.item');
    Route::post('delete-item', [AjaxTourismController::class, 'deleteItem'])->name('panel.ajax.tourism.delete.item');
    Route::post('add-insurance', [AjaxTourismController::class, 'addInsurance'])->name('panel.ajax.tourism.add.insurance');
    Route::post('delete-insurance', [AjaxTourismController::class, 'deleteInsurance'])->name('panel.ajax.tourism.delete.insurance');
    Route::get('/tourism/search/zone', [AjaxTourismController::class, 'searchZone'])->name('panel.ajax.tourism.search.zone');
    Route::get('/tourism/select/hotel', [AjaxTourismController::class, 'selectHotel'])->name('panel.ajax.tourism.select.hotel');
    Route::get('/budget/escala/send', [TourismController::class, 'escalaSend'])->name('panel.budget.escala.send');
    Route::get('/budget/escala/print/{budget}', [TourismController::class, 'print'])->name('panel.budget.print');
});

Route::get('logout', [LoginController::class, 'logout'])->name('logout.get');
